/*
 * Decompiled with CFR 0.152.
 */
package org.modelevolution.multiview.mc.ui.view;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.part.ViewPart;
import org.modelevolution.multiview.Region;
import org.modelevolution.multiview.State;
import org.modelevolution.multiview.mc.ui.MCEncodingUIPlugin;
import org.modelevolution.multiview.mc.ui.model.Configuration;
import org.modelevolution.multiview.mc.ui.model.ConfigurationModel;
import org.modelevolution.multiview.mc.ui.provider.ConfigurationContentProvider;
import org.modelevolution.multiview.mc.ui.util.ViewUtil;

public class MCEncodingView
extends ViewPart
implements PropertyChangeListener {
    private static MCEncodingView instance;
    private TreeViewer viewer;

    public MCEncodingView() {
        instance = this;
    }

    public static MCEncodingView getInstance() {
        if (instance == null) {
            instance = new MCEncodingView();
        }
        return instance;
    }

    public void createPartControl(Composite parent) {
        this.viewer = new TreeViewer(parent, 256);
        TreeViewerColumn colFirst = new TreeViewerColumn(this.viewer, 16384);
        colFirst.getColumn().setWidth(10);
        colFirst.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return null;
            }
        });
        TreeViewerColumn colResult = new TreeViewerColumn(this.viewer, 16384);
        colResult.getColumn().setWidth(10);
        colResult.getColumn().setText("");
        colResult.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return null;
            }

            public Color getBackground(Object element) {
                Configuration config;
                if (element instanceof Configuration && (config = (Configuration)element).getEvaluation() != null) {
                    return ViewUtil.getColor(config.getExpectedOutcome(), config.getEvaluation().getEffectiveOutcome());
                }
                return super.getBackground(element);
            }
        });
        TreeViewerColumn colGoal = new TreeViewerColumn(this.viewer, 16384);
        colGoal.getColumn().setWidth(450);
        colGoal.getColumn().setText("Goals");
        colGoal.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof Configuration) {
                    Configuration config = (Configuration)element;
                    StringBuffer goals = new StringBuffer();
                    if (config.getGoal() != null) {
                        Iterator<State> it = config.getGoal().iterator();
                        while (it.hasNext()) {
                            State s = it.next();
                            goals.append(s.getName());
                            goals.append(" [" + ((Region)s.eContainer()).getName() + "]");
                            if (!it.hasNext()) continue;
                            goals.append(", ");
                        }
                    } else {
                        goals.append("no goal defined");
                    }
                    return goals.toString();
                }
                if (element instanceof String) {
                    return (String)element;
                }
                return null;
            }
        });
        TreeViewerColumn colBound = new TreeViewerColumn(this.viewer, 16384);
        colBound.getColumn().setWidth(80);
        colBound.getColumn().setText("Bound");
        colBound.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof Configuration) {
                    Configuration config = (Configuration)element;
                    return new Integer(config.getBound()).toString();
                }
                return null;
            }
        });
        TreeViewerColumn colExpectedOutcome = new TreeViewerColumn(this.viewer, 16384);
        colExpectedOutcome.getColumn().setWidth(140);
        colExpectedOutcome.getColumn().setText("Expected Outcome");
        colExpectedOutcome.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Configuration config;
                if (element instanceof Configuration && (config = (Configuration)element).getExpectedOutcome() != null) {
                    return config.getExpectedOutcome().name();
                }
                return null;
            }
        });
        TreeViewerColumn colEffectiveOutcome = new TreeViewerColumn(this.viewer, 16384);
        colEffectiveOutcome.getColumn().setWidth(140);
        colEffectiveOutcome.getColumn().setText("Effective Outcome");
        colEffectiveOutcome.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Configuration config;
                if (element instanceof Configuration && (config = (Configuration)element).getEvaluation() != null) {
                    return config.getEvaluation().getEffectiveOutcome().name();
                }
                return null;
            }
        });
        TreeViewerColumn colTimeEncoding = new TreeViewerColumn(this.viewer, 131072);
        colTimeEncoding.getColumn().setWidth(80);
        colTimeEncoding.getColumn().setText("Time Encoding");
        colTimeEncoding.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Configuration config;
                if (element instanceof Configuration && (config = (Configuration)element).getEvaluation() != null) {
                    return String.valueOf(new Long(config.getEvaluation().getTimeEncoding()).toString()) + " ms";
                }
                return null;
            }
        });
        TreeViewerColumn colTimeSolving = new TreeViewerColumn(this.viewer, 131072);
        colTimeSolving.getColumn().setWidth(80);
        colTimeSolving.getColumn().setText("Time Solving");
        colTimeSolving.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Configuration config;
                if (element instanceof Configuration && (config = (Configuration)element).getEvaluation() != null) {
                    return String.valueOf(new Long(config.getEvaluation().getTimeSolving()).toString()) + " ms";
                }
                return null;
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Configuration config;
                StructuredSelection selection;
                if (event.getSelection() instanceof StructuredSelection && (selection = (StructuredSelection)event.getSelection()).getFirstElement() instanceof Configuration && (config = (Configuration)selection.getFirstElement()).getEvaluation() != null) {
                    ViewUtil.colorShapes(config.getGoalEditParts(), ViewUtil.getColor(config.getExpectedOutcome(), config.getEvaluation().getEffectiveOutcome()), ViewUtil.getColor(config.getExpectedOutcome(), config.getEvaluation().getEffectiveOutcome()), 60);
                }
            }
        });
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.viewer.setContentProvider((IContentProvider)new ConfigurationContentProvider());
        this.viewer.setInput((Object)MCEncodingUIPlugin.getDefault().getConfigurations());
        ConfigurationModel configurationModel = MCEncodingUIPlugin.getDefault().getConfigurations();
        MCEncodingUIPlugin.getDefault().getConfigurations();
        configurationModel.addPropertyChangeListener("configItems", this);
        Tree tree = this.viewer.getTree();
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.viewer.setInput((Object)MCEncodingUIPlugin.getDefault().getConfigurations().getConfigItems().toArray());
        this.viewer.refresh();
    }
}

