/*
 * Decompiled with CFR 0.152.
 */
package org.modelevolution.multiview.mc.ui.handler;

import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.modelevolution.multiview.State;
import org.modelevolution.multiview.StateView;
import org.modelevolution.multiview.mc.encoding.engine.impl.EncodingEngineReachability;
import org.modelevolution.multiview.mc.ui.model.Evaluation;
import org.modelevolution.multiview.mc.ui.model.Outcome;
import org.sat4j.minisat.SolverFactory;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.TimeoutException;

public class EvaluationHandler {
    public static Evaluation performEvaluation(StateView stateView, Set<State> selectedStates, int bound, IProgressMonitor monitor) throws ContradictionException, TimeoutException {
        long initTime = System.currentTimeMillis();
        monitor.subTask("Generate encoding");
        ISolver solver = SolverFactory.newDefault();
        EncodingEngineReachability encodingEngine = new EncodingEngineReachability(solver);
        encodingEngine.generateEncoding(stateView, bound, selectedStates, monitor);
        Evaluation eval = new Evaluation();
        eval.setTimeEncoding(System.currentTimeMillis() - initTime);
        monitor.subTask("Analyze outcome");
        if (solver.isSatisfiable()) {
            eval.setTrace(encodingEngine.getModelText(solver.model()));
            eval.setEffectiveOutcome(Outcome.REACHABLE);
        } else {
            eval.setEffectiveOutcome(Outcome.NOT_REACHABLE);
        }
        eval.setTimeSolving(System.currentTimeMillis() - initTime);
        return eval;
    }
}

