/*
 * Decompiled with CFR 0.152.
 */
package org.modelevolution.multiview.mc.ui;

import java.io.File;
import java.util.HashSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.modelevolution.multiview.MultiviewModel;
import org.modelevolution.multiview.MultiviewPackage;
import org.modelevolution.multiview.Region;
import org.modelevolution.multiview.State;
import org.modelevolution.multiview.StateView;
import org.modelevolution.multiview.mc.encoding.engine.impl.EncodingEngineReachability;
import org.sat4j.minisat.SolverFactory;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.TimeoutException;

public class MCEncodingRunner {
    public static final String MVML_FILE_EXTENSION = "mvml";
    Resource resource;

    MCEncodingRunner(String filename) {
        System.out.println("Running " + filename);
        long initTime = System.currentTimeMillis();
        this.setUp(filename);
        MultiviewModel mmmodel = (MultiviewModel)this.resource.getContents().get(0);
        StateView stateView = mmmodel.getStateview();
        ISolver solver = SolverFactory.newDefault();
        EncodingEngineReachability encodingEngine = new EncodingEngineReachability(solver);
        int bound = 5;
        HashSet<State> goal = new HashSet<State>();
        State goalStatePhil1eat = (State)((Region)stateView.getStatemachines().get(0)).getStates().get(3);
        State cfr_ignored_0 = (State)((Region)stateView.getStatemachines().get(1)).getStates().get(1);
        State goalStatePhil1hasLeft = (State)((Region)stateView.getStatemachines().get(0)).getStates().get(2);
        State cfr_ignored_1 = (State)((Region)stateView.getStatemachines().get(2)).getStates().get(3);
        State cfr_ignored_2 = (State)((Region)stateView.getStatemachines().get(3)).getStates().get(1);
        State goalStatePhil2hasLeft = (State)((Region)stateView.getStatemachines().get(2)).getStates().get(2);
        State cfr_ignored_3 = (State)((Region)stateView.getStatemachines().get(4)).getStates().get(3);
        State cfr_ignored_4 = (State)((Region)stateView.getStatemachines().get(5)).getStates().get(1);
        State goalStatePhil3hasLeft = (State)((Region)stateView.getStatemachines().get(4)).getStates().get(2);
        goal.add(goalStatePhil1hasLeft);
        goal.add(goalStatePhil2hasLeft);
        goal.add(goalStatePhil3hasLeft);
        System.out.println(goalStatePhil1eat.getName());
        System.out.println("Goal: ");
        for (State state : goal) {
            System.out.println("\t" + state.getName());
        }
        System.out.println();
        try {
            encodingEngine.generateEncoding(stateView, bound, goal, (IProgressMonitor)new NullProgressMonitor());
            System.out.println("Encoding\t " + (System.currentTimeMillis() - initTime) + "ms");
            if (solver.isSatisfiable()) {
                System.out.println("\nGoal state is reachable ");
                encodingEngine.printModel(solver.model());
            } else {
                System.out.println("\nGoal state is not reachable ");
            }
            System.out.println("Solving\t\t " + (System.currentTimeMillis() - initTime) + "ms");
        }
        catch (ContradictionException e1) {
            e1.printStackTrace();
            System.out.println("Trivial contradiction, goal state not reachable");
            this.tearDown();
        }
        catch (TimeoutException e) {
            e.printStackTrace();
        }
        this.tearDown();
    }

    private void setUp(String filename) {
        EPackage.Registry.INSTANCE.put((Object)MultiviewPackage.eINSTANCE.getNsURI(), (Object)MultiviewPackage.eINSTANCE);
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put(MVML_FILE_EXTENSION, new XMIResourceFactoryImpl());
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put(MVML_FILE_EXTENSION, new XMIResourceFactoryImpl());
        URI fileURI_id = URI.createFileURI((String)new File(filename).getAbsolutePath());
        this.resource = resourceSet.getResource(fileURI_id, true);
    }

    private void tearDown() {
        this.resource.unload();
    }

    public static void main(String[] args) {
        new MCEncodingRunner(args[0]);
    }
}

