/*
 * Decompiled with CFR 0.152.
 */
package org.modelevolution.multiview.mc.ui.util;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Shape;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.modelevolution.multiview.mc.ui.model.Outcome;

public class ViewUtil {
    public static Color COLOR_DEFAULT_FOREGROUND = ColorConstants.white;
    public static Color COLOR_DEFAULT_BACKGROUND = ColorConstants.black;
    public static final Color COLOR_EXPECTED = new Color((Device)Display.getCurrent(), 0, 170, 0);
    public static final Color COLOR_NOT_EXPECTED = new Color((Device)Display.getCurrent(), 225, 0, 0);
    public static final int ALPHA = 60;
    public static Set<EditPart> currentHighlighting = new HashSet<EditPart>();

    public static void colorShapes(Set<EditPart> selectedEditParts, Color foreground, Color background, int alpha) {
        ViewUtil.resetColors();
        if (selectedEditParts != null) {
            for (EditPart e : selectedEditParts) {
                if (!(e instanceof IGraphicalEditPart)) continue;
                IGraphicalEditPart ge = (IGraphicalEditPart)e;
                IFigure f = ge.getFigure();
                for (Object o : f.getChildren()) {
                    IFigure c = (IFigure)o;
                    c.setBackgroundColor(background);
                    ViewUtil.setAlpha(c, alpha);
                }
                f.repaint();
            }
            currentHighlighting = selectedEditParts;
        }
    }

    private static void setAlpha(IFigure figure, int alpha) {
        if (figure instanceof Shape) {
            ((Shape)figure).setAlpha(alpha);
            List children = figure.getChildren();
            for (Figure child : children) {
                ViewUtil.setAlpha((IFigure)child, 0);
            }
        }
    }

    public static void resetColors() {
        if (currentHighlighting != null) {
            for (EditPart e : currentHighlighting) {
                if (!(e instanceof IGraphicalEditPart)) continue;
                IGraphicalEditPart ge = (IGraphicalEditPart)e;
                IFigure f = ge.getFigure();
                for (Object o : f.getChildren()) {
                    IFigure c = (IFigure)o;
                    c.setBackgroundColor(COLOR_DEFAULT_BACKGROUND);
                    ViewUtil.setAlpha(c, 100);
                }
                f.repaint();
            }
        }
    }

    public static Color getColor(Outcome expectedOutcome, Outcome effectiveOutcome) {
        if (expectedOutcome.equals((Object)effectiveOutcome)) {
            return COLOR_EXPECTED;
        }
        return COLOR_NOT_EXPECTED;
    }
}

