/*
 * Decompiled with CFR 0.152.
 */
package org.modelevolution.multiview.mc.ui.view;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.eclipse.ui.part.ViewPart;
import org.modelevolution.multiview.Region;
import org.modelevolution.multiview.State;
import org.modelevolution.multiview.mc.ui.MCEncodingUIPlugin;
import org.modelevolution.multiview.mc.ui.handler.EvaluationHandler;
import org.modelevolution.multiview.mc.ui.model.Configuration;
import org.modelevolution.multiview.mc.ui.model.Evaluation;
import org.modelevolution.multiview.mc.ui.provider.ConfigurationContentProvider;
import org.modelevolution.multiview.mc.ui.util.ViewUtil;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.TimeoutException;

public class MCEncodingView
extends ViewPart
implements PropertyChangeListener {
    public static final String ID = "org.modelevolution.multiview.mc.console";
    private static MCEncodingView instance;
    private TreeViewer viewer;

    public MCEncodingView() {
        instance = this;
    }

    public static MCEncodingView getInstance() {
        if (instance == null) {
            instance = new MCEncodingView();
        }
        return instance;
    }

    public void createPartControl(Composite parent) {
        this.viewer = new TreeViewer(parent, 0x10000000);
        TreeViewerColumn colFirst = new TreeViewerColumn(this.viewer, 0);
        colFirst.getColumn().setWidth(10);
        colFirst.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return null;
            }
        });
        TreeViewerColumn colResult = new TreeViewerColumn(this.viewer, 0);
        colResult.getColumn().setWidth(10);
        colResult.getColumn().setText("");
        colResult.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return null;
            }

            public Color getBackground(Object element) {
                Configuration config;
                if (element instanceof Configuration && (config = (Configuration)element).getEvaluation() != null) {
                    return ViewUtil.getColor(config.getExpectedOutcome(), config.getEvaluation().getEffectiveOutcome());
                }
                return super.getBackground(element);
            }
        });
        TreeViewerColumn colGoal = new TreeViewerColumn(this.viewer, 0);
        colGoal.getColumn().setWidth(450);
        colGoal.getColumn().setText("Goals");
        colGoal.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof Configuration) {
                    Configuration config = (Configuration)element;
                    StringBuffer goals = new StringBuffer();
                    if (config.getGoal() != null) {
                        Iterator<State> it = config.getGoal().iterator();
                        while (it.hasNext()) {
                            State s = it.next();
                            goals.append(s.getName());
                            goals.append(" [" + ((Region)s.eContainer()).getName() + "]");
                            if (!it.hasNext()) continue;
                            goals.append(", ");
                        }
                    } else {
                        goals.append("no goal defined");
                    }
                    return goals.toString();
                }
                if (element instanceof String) {
                    return (String)element;
                }
                return null;
            }
        });
        TreeViewerColumn colBound = new TreeViewerColumn(this.viewer, 0);
        colBound.getColumn().setWidth(80);
        colBound.getColumn().setText("Bound");
        colBound.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof Configuration) {
                    Configuration config = (Configuration)element;
                    return new Integer(config.getBound()).toString();
                }
                return null;
            }
        });
        TreeViewerColumn colExpectedOutcome = new TreeViewerColumn(this.viewer, 16384);
        colExpectedOutcome.getColumn().setWidth(140);
        colExpectedOutcome.getColumn().setText("Expected Outcome");
        colExpectedOutcome.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Configuration config;
                if (element instanceof Configuration && (config = (Configuration)element).getExpectedOutcome() != null) {
                    return config.getExpectedOutcome().name();
                }
                return null;
            }
        });
        TreeViewerColumn colEffectiveOutcome = new TreeViewerColumn(this.viewer, 0);
        colEffectiveOutcome.getColumn().setWidth(140);
        colEffectiveOutcome.getColumn().setText("Effective Outcome");
        colEffectiveOutcome.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Configuration config;
                if (element instanceof Configuration && (config = (Configuration)element).getEvaluation() != null) {
                    return config.getEvaluation().getEffectiveOutcome().name();
                }
                return null;
            }
        });
        TreeViewerColumn colTimeEncoding = new TreeViewerColumn(this.viewer, 0);
        colTimeEncoding.getColumn().setWidth(80);
        colTimeEncoding.getColumn().setText("Time Encoding");
        colTimeEncoding.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Configuration config;
                if (element instanceof Configuration && (config = (Configuration)element).getEvaluation() != null) {
                    return String.valueOf(new Long(config.getEvaluation().getTimeEncoding()).toString()) + " ms";
                }
                return null;
            }
        });
        TreeViewerColumn colTimeSolving = new TreeViewerColumn(this.viewer, 0);
        colTimeSolving.getColumn().setWidth(80);
        colTimeSolving.getColumn().setText("Time Solving");
        colTimeSolving.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Configuration config;
                if (element instanceof Configuration && (config = (Configuration)element).getEvaluation() != null) {
                    return String.valueOf(new Long(config.getEvaluation().getTimeSolving()).toString()) + " ms";
                }
                return null;
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Configuration config;
                StructuredSelection selection;
                if (event.getSelection() instanceof StructuredSelection && (selection = (StructuredSelection)event.getSelection()).getFirstElement() instanceof Configuration && (config = (Configuration)selection.getFirstElement()).getEvaluation() != null) {
                    ViewUtil.colorShapes(config.getGoalEditParts(), ViewUtil.getColor(config.getExpectedOutcome(), config.getEvaluation().getEffectiveOutcome()), ViewUtil.getColor(config.getExpectedOutcome(), config.getEvaluation().getEffectiveOutcome()), 60);
                }
            }
        });
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        final MenuManager menuMgr = new MenuManager();
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                IStructuredSelection selection;
                if (MCEncodingView.this.viewer.getSelection().isEmpty()) {
                    return;
                }
                if (MCEncodingView.this.viewer.getSelection() instanceof IStructuredSelection && (selection = (IStructuredSelection)MCEncodingView.this.viewer.getSelection()).getFirstElement() instanceof Configuration) {
                    menuMgr.add((IAction)new BaseSelectionListenerAction("Run Configuration"){

                        public void run() {
                            try {
                                MCEncodingUIPlugin.getDefault().getWorkbench().getProgressService().run(false, true, new IRunnableWithProgress(){

                                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                        try {
                                            Configuration configItem = (Configuration)selection.getFirstElement();
                                            Evaluation eval = EvaluationHandler.performEvaluation(configItem.getStateView(), configItem.getGoal(), configItem.getBound(), monitor);
                                            configItem.setEvaluation(eval);
                                        }
                                        catch (ContradictionException | TimeoutException e) {
                                            MCEncodingUIPlugin.log(Level.SEVERE, e.getMessage());
                                        }
                                    }
                                });
                            }
                            catch (InterruptedException | InvocationTargetException e) {
                                MCEncodingUIPlugin.log(Level.SEVERE, e.getMessage());
                                e.printStackTrace();
                            }
                        }
                    });
                    menuMgr.add((IAction)new BaseSelectionListenerAction("Delete Configuration"){

                        public void run() {
                            if (selection != null && selection instanceof IStructuredSelection) {
                                for (Configuration configItem : selection) {
                                    MCEncodingUIPlugin.getDefault().getConfigurations().removeConfigItems(configItem);
                                }
                            }
                        }
                    });
                }
            }
        });
        menuMgr.setRemoveAllWhenShown(true);
        this.viewer.getControl().setMenu(menu);
        this.viewer.setContentProvider((IContentProvider)new ConfigurationContentProvider());
        this.viewer.setInput((Object)MCEncodingUIPlugin.getDefault().getConfigurations());
        MCEncodingUIPlugin.getDefault().getConfigurations().addPropertyChangeListener("configItems", this);
        Tree tree = this.viewer.getTree();
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.viewer.setInput((Object)MCEncodingUIPlugin.getDefault().getConfigurations().getConfigItems().toArray());
        this.viewer.refresh();
    }
}

