/*
 * Decompiled with CFR 0.152.
 */
package org.modelevolution.multiview.sc.ui.view;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.part.ViewPart;
import org.modelevolution.multiview.Message;
import org.modelevolution.multiview.Region;
import org.modelevolution.multiview.State;
import org.modelevolution.multiview.Symbol;
import org.modelevolution.multiview.Transition;
import org.modelevolution.multiview.mc.encoding.engine.impl.StateLifeline;
import org.modelevolution.multiview.mc.encoding.engine.impl.TransitionLifeline;
import org.modelevolution.multiview.sc.ui.SequenceCheckerUiPlugin;
import org.modelevolution.multiview.sc.ui.handler.ResultType;
import org.modelevolution.multiview.sc.ui.model.GlobalState;
import org.modelevolution.multiview.sc.ui.model.IntermediateTransition;
import org.modelevolution.multiview.sc.ui.provider.SequenceContentProvider;
import org.modelevolution.multiview.sc.ui.view.ViewUtil;

public class SequenceCheckerView
extends ViewPart
implements PropertyChangeListener {
    private static SequenceCheckerView instance;
    public static final String ID = "org.modelevolution.multiview.sc.console";
    private Composite composite;
    private CLabel infoLabel;
    private TreeViewer viewer;

    public SequenceCheckerView() {
        instance = this;
    }

    public SequenceCheckerView getInstance() {
        if (instance == null) {
            instance = new SequenceCheckerView();
        }
        return instance;
    }

    public void createPartControl(Composite parent) {
        this.composite = new Composite(parent, 0);
        RowLayout layout = new RowLayout(512);
        this.composite.setLayout((Layout)layout);
        this.infoLabel = new CLabel(this.composite, 16384);
        this.infoLabel.setLayout((Layout)new FillLayout(256));
        this.updateInfoLabel();
        this.infoLabel.setVisible(true);
        this.viewer = new TreeViewer(this.composite, 0x10000000);
        TreeViewerColumn colTime = new TreeViewerColumn(this.viewer, 0);
        colTime.getColumn().setText("Step");
        colTime.getColumn().setWidth(80);
        colTime.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof GlobalState) {
                    return ((GlobalState)element).getStep().toString();
                }
                return null;
            }
        });
        TreeViewerColumn colMsg = new TreeViewerColumn(this.viewer, 0);
        colMsg.getColumn().setText("Msg");
        colMsg.getColumn().setWidth(250);
        colMsg.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof GlobalState && ((GlobalState)element).getEnclosingMessage() != null) {
                    return ((GlobalState)element).getEnclosingMessage().toString();
                }
                return null;
            }
        });
        TreeViewerColumn colState = new TreeViewerColumn(this.viewer, 16384);
        colState.getColumn().setText("Global State");
        colState.getColumn().setWidth(2000);
        colState.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Set symbolSet;
                if (element != null && element instanceof GlobalState) {
                    GlobalState gs = (GlobalState)element;
                    Iterator<StateLifeline> it = gs.getStates().iterator();
                    Iterator<IntermediateTransition> itt = gs.getIntermediateTransition().iterator();
                    if (!it.hasNext() && !itt.hasNext()) {
                        return "Not reachable";
                    }
                    StringBuilder states = new StringBuilder("[");
                    while (it.hasNext()) {
                        StateLifeline sl = it.next();
                        Region rtRegion = SequenceCheckerUiPlugin.getDefault().getGlobalStateModel().getLifeline2regionMap().get(sl.getLifeline().getName());
                        if (rtRegion != null) {
                            states.append(rtRegion.getName());
                            states.append(": ");
                        }
                        State s = sl.getState();
                        states.append(s.getName());
                        states.append(", ");
                    }
                    while (itt.hasNext()) {
                        TransitionLifeline tl = itt.next().getTransitionLifeline();
                        Transition t = tl.getTransition();
                        Region rtRegion = SequenceCheckerUiPlugin.getDefault().getGlobalStateModel().getLifeline2regionMap().get(tl.getLifeline().getName());
                        if (rtRegion != null) {
                            states.append(rtRegion.getName());
                            states.append(" (IntermediateTransition): ");
                        }
                        states.append(t);
                        states.append(", ");
                    }
                    states.replace(states.length() - 2, states.length(), "]");
                    return states.toString();
                }
                if (element != null && element instanceof Message) {
                    return "Sent Message: " + element.toString();
                }
                if (element != null && element instanceof TransitionLifeline) {
                    Region rtRegion;
                    TransitionLifeline tl = (TransitionLifeline)element;
                    if (tl.getLifeline() != null && tl.getTransition() != null && (rtRegion = SequenceCheckerUiPlugin.getDefault().getGlobalStateModel().getLifeline2regionMap().get(tl.getLifeline().getName())) != null) {
                        return "Triggered Transition: " + rtRegion.getName() + " -> " + tl.getTransition();
                    }
                } else if (element != null && element instanceof Set && !(symbolSet = (Set)element).isEmpty()) {
                    StringBuilder symbols = new StringBuilder();
                    symbols.append("Consumable Symbols: ");
                    for (Object o : symbolSet) {
                        if (!(o instanceof Symbol)) continue;
                        Symbol s = (Symbol)o;
                        symbols.append(s.getName());
                        symbols.append(", ");
                    }
                    return symbols.substring(0, symbols.length() - 2).toString();
                }
                return super.getText(element);
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection() instanceof StructuredSelection) {
                    TreeSelection selection = (TreeSelection)event.getSelection();
                    if (selection.getFirstElement() instanceof GlobalState) {
                        GlobalState gs = (GlobalState)selection.getFirstElement();
                        ViewUtil.highlightGlobalState(gs);
                    } else {
                        Object parent;
                        TreePath[] path = selection.getPaths();
                        if (path != null && path.length > 0 && (parent = path[0].getFirstSegment()) != null && parent instanceof GlobalState) {
                            GlobalState gs = (GlobalState)parent;
                            ViewUtil.highlightGlobalState(gs);
                        }
                    }
                }
            }
        });
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.viewer.setContentProvider((IContentProvider)new SequenceContentProvider());
        this.viewer.setInput((Object)SequenceCheckerUiPlugin.getDefault().getGlobalStateModel());
        this.viewer.setAutoExpandLevel(-1);
        this.composite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                SequenceCheckerView.this.composite.pack();
                SequenceCheckerView.this.composite.layout();
            }
        });
        SequenceCheckerUiPlugin.getDefault().getGlobalStateModel().addPropertyChangeListener("org.modelevolution.multiview.sc.ui.model.GlobalState", this);
        Tree tree = this.viewer.getTree();
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        this.composite.pack();
        this.composite.layout();
        parent.layout();
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.viewer.setInput((Object)SequenceCheckerUiPlugin.getDefault().getGlobalStateModel().getTrace().toArray());
        this.viewer.refresh();
        this.updateInfoLabel();
        this.composite.pack();
        this.composite.layout();
    }

    private void updateInfoLabel() {
        this.infoLabel.setText(SequenceCheckerUiPlugin.getDefault().getGlobalStateModel().getResult().getInfo());
        if (SequenceCheckerUiPlugin.getDefault().getGlobalStateModel().getResult().equals((Object)ResultType.OK)) {
            Image image = this.infoLabel.getDisplay().getSystemImage(2);
            this.infoLabel.setImage(this.scale(image));
        } else if (SequenceCheckerUiPlugin.getDefault().getGlobalStateModel().getResult().equals((Object)ResultType.BUG)) {
            Image image = this.infoLabel.getDisplay().getSystemImage(1);
            this.infoLabel.setImage(this.scale(image));
        } else if (SequenceCheckerUiPlugin.getDefault().getGlobalStateModel().getResult().equals((Object)ResultType.NONE)) {
            this.infoLabel.setImage(null);
        }
        this.infoLabel.update();
        this.infoLabel.layout();
    }

    private Image scale(Image image) {
        return new Image((Device)this.infoLabel.getDisplay(), image.getImageData().scaledTo(16, 16));
    }
}

