/*
 * Decompiled with CFR 0.152.
 */
package org.modelevolution.multiview.sc.ui.handler;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.modelevolution.multiview.Message;
import org.modelevolution.multiview.MultiviewModel;
import org.modelevolution.multiview.Symbol;
import org.modelevolution.multiview.Transition;
import org.modelevolution.multiview.mc.encoding.engine.impl.EncodingEngineCheckSequence;
import org.modelevolution.multiview.mc.encoding.engine.impl.StateLifeline;
import org.modelevolution.multiview.mc.encoding.engine.impl.TransitionLifeline;
import org.modelevolution.multiview.sc.ui.SequenceCheckerUiPlugin;
import org.modelevolution.multiview.sc.ui.handler.ResultType;
import org.modelevolution.multiview.sc.ui.model.GlobalState;
import org.modelevolution.multiview.sc.ui.model.GlobalStateModel;
import org.modelevolution.multiview.sc.ui.model.IntermediateTransition;
import org.sat4j.minisat.SolverFactory;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.TimeoutException;

public class EvaluationHandler {
    public static GlobalStateModel performEvaluation(MultiviewModel mvmodel, int bound, IProgressMonitor monitor) throws ContradictionException, TimeoutException {
        ResultType result;
        EList messages = mvmodel.getSequenceview().getMessages();
        monitor.beginTask("Checking sequence occurence in statemachine view", messages.size() * 2);
        GlobalStateModel globalStateModel = new GlobalStateModel();
        int lastMsgIndex = messages.size();
        while (lastMsgIndex > 0) {
            monitor.subTask("Generate encoding");
            ISolver solver = SolverFactory.newDefault();
            EncodingEngineCheckSequence encodingEngine = new EncodingEngineCheckSequence(solver);
            encodingEngine.generateEncoding(mvmodel, lastMsgIndex, bound, monitor);
            monitor.worked(1);
            monitor.subTask("Analyze outcome");
            if (solver.isSatisfiable()) {
                Map varMap = encodingEngine.getVariableMap();
                List modelText = encodingEngine.getModelText(solver.model());
                int previousStep = -1;
                int currentStep = -1;
                int realStep = 1;
                GlobalState globalState = null;
                for (String s : modelText) {
                    currentStep = Integer.parseInt(s.substring(1, s.indexOf("-")));
                    if (currentStep > previousStep) {
                        if (!EvaluationHandler.checkStep(globalState)) {
                            globalStateModel.getTrace().remove(globalState);
                        } else {
                            ++realStep;
                        }
                        globalState = new GlobalState();
                        globalState.setStep(realStep);
                        globalStateModel.addTraceElement(globalState);
                        previousStep = currentStep;
                    }
                    if (varMap.get(s) == null) continue;
                    if (varMap.get(s) instanceof StateLifeline) {
                        StateLifeline sl = (StateLifeline)varMap.get(s);
                        globalState.addState(sl);
                        continue;
                    }
                    if (varMap.get(s) instanceof TransitionLifeline) {
                        TransitionLifeline tl = (TransitionLifeline)varMap.get(s);
                        String transitionType = s.substring(s.indexOf("-") + 1, s.indexOf(":"));
                        if ("T".equals(transitionType)) {
                            globalState.setTransition(tl);
                            continue;
                        }
                        if (!"I".equals(transitionType)) continue;
                        globalState.addIntermediateTransition(tl);
                        continue;
                    }
                    if (varMap.get(s) instanceof Message) {
                        Message m = (Message)varMap.get(s);
                        globalState.setSentMessage(m);
                        continue;
                    }
                    if (varMap.get(s) instanceof Symbol) {
                        Symbol symbol = (Symbol)varMap.get(s);
                        globalState.addSymbol(symbol);
                        continue;
                    }
                    Object o = varMap.get(s);
                    SequenceCheckerUiPlugin.log(Level.INFO, String.valueOf(currentStep) + "\tUnknown Type:\t" + o.getClass() + "\t" + o);
                }
                monitor.worked(1);
                break;
            }
            SequenceCheckerUiPlugin.log(Level.INFO, "UNSAT: removing last message.");
            --lastMsgIndex;
            monitor.worked(1);
        }
        globalStateModel.setLastMsgIndex(lastMsgIndex);
        boolean fullTrace = lastMsgIndex == messages.size();
        boolean desiredScenario = mvmodel.getSequenceview().getFragments().isEmpty();
        if (fullTrace && desiredScenario) {
            result = ResultType.OK;
            result.setResult("The desired sequence is consistent with the state machines.");
            globalStateModel.setResult(result);
        } else if (!fullTrace && desiredScenario) {
            result = ResultType.BUG;
            result.setResult("The desired sequence is inconsistent with the state machines.");
            globalStateModel.setResult(result);
        } else if (!fullTrace && !desiredScenario) {
            result = ResultType.OK;
            result.setResult("The forbidden sequence is inconsistent with the state machines.");
            globalStateModel.setResult(result);
        } else if (fullTrace && !desiredScenario) {
            result = ResultType.BUG;
            result.setResult("The forbidden sequence is executeable by the state machines.");
            globalStateModel.setResult(result);
        }
        monitor.done();
        return globalStateModel;
    }

    private static boolean checkStep(GlobalState globalState) {
        Transition transition;
        if (globalState != null && globalState.getTransition() != null && globalState.getTransition().getTransition() != null && (transition = globalState.getTransition().getTransition()) != null && transition.getTrigger() != null) {
            Symbol trigger = transition.getTrigger();
            Set<Symbol> symbols = globalState.getSymbols();
            Set<IntermediateTransition> intermediateTransitions = globalState.getIntermediateTransition();
            if (symbols != null && symbols.contains(trigger)) {
                for (IntermediateTransition intermediate : intermediateTransitions) {
                    if (intermediate == null || intermediate.getTransitionLifeline() == null || intermediate.getTransitionLifeline().getTransition() == null || intermediate.getTransitionLifeline().getTransition().getEffects() == null || !intermediate.getTransitionLifeline().getTransition().getEffects().contains((Object)trigger)) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

