/*
 * Decompiled with CFR 0.152.
 */
package org.modelevolution.multiview.sc.ui.model;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashSet;
import java.util.Set;
import org.modelevolution.multiview.Message;
import org.modelevolution.multiview.Symbol;
import org.modelevolution.multiview.mc.encoding.engine.impl.StateLifeline;
import org.modelevolution.multiview.mc.encoding.engine.impl.TransitionLifeline;
import org.modelevolution.multiview.sc.ui.model.IntermediateTransition;

public class GlobalState {
    public static final String PROPERTY_STEP = "org.modelevolution.multiview.sc.ui.model.GlobalState.step";
    public static final String PROPERTY_GLOBALSTATE = "org.modelevolution.multiview.sc.ui.model.GlobalState.globalstate";
    public static final String PROPERTY_MESSAGE = "org.modelevolution.multiview.sc.ui.model.GlobalState.message";
    public static final String PROPERTY_TRANSITION = "org.modelevolution.multiview.sc.ui.model.GlobalState.transition";
    public static final String PROPERTY_SYMBOL = "org.modelevolution.multiview.sc.ui.model.GlobalState.symbols";
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private Integer step;
    private Set<StateLifeline> states = new HashSet<StateLifeline>();
    private Set<IntermediateTransition> intermediateTransition = new HashSet<IntermediateTransition>();
    private Message sentMessage;
    private Message enclosingMessage;
    private TransitionLifeline transition;
    private Set<Symbol> symbols = new HashSet<Symbol>();

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void setStep(Integer step) {
        this.step = step;
        this.propertyChangeSupport.firePropertyChange(PROPERTY_STEP, this.step, this.step);
    }

    public Integer getStep() {
        return this.step;
    }

    public void setStates(Set<StateLifeline> states) {
        this.states = states;
        this.propertyChangeSupport.firePropertyChange(PROPERTY_GLOBALSTATE, this.states, this.states);
    }

    public void addState(StateLifeline state) {
        this.propertyChangeSupport.firePropertyChange(PROPERTY_GLOBALSTATE, this.states, (Object)this.states.add(state));
    }

    public Set<StateLifeline> getStates() {
        return this.states;
    }

    public void setIntermediateTransition(Set<TransitionLifeline> transitions) {
        HashSet<IntermediateTransition> newIntermediateTransitions = new HashSet<IntermediateTransition>();
        for (TransitionLifeline t : transitions) {
            newIntermediateTransitions.add(new IntermediateTransition(t));
        }
        this.intermediateTransition = newIntermediateTransitions;
        this.propertyChangeSupport.firePropertyChange(PROPERTY_GLOBALSTATE, this.intermediateTransition, this.intermediateTransition);
    }

    public void addIntermediateTransition(TransitionLifeline transition) {
        this.propertyChangeSupport.firePropertyChange(PROPERTY_GLOBALSTATE, this.intermediateTransition, (Object)this.intermediateTransition.add(new IntermediateTransition(transition)));
    }

    public Set<IntermediateTransition> getIntermediateTransition() {
        return this.intermediateTransition;
    }

    public void setSentMessage(Message message) {
        this.sentMessage = message;
        this.propertyChangeSupport.firePropertyChange(PROPERTY_MESSAGE, this.sentMessage, this.sentMessage);
    }

    public Message getSentMessage() {
        return this.sentMessage;
    }

    public void setEnclosingMessage(Message message) {
        this.enclosingMessage = message;
        this.propertyChangeSupport.firePropertyChange(PROPERTY_MESSAGE, this.enclosingMessage, this.enclosingMessage);
    }

    public Message getEnclosingMessage() {
        return this.enclosingMessage;
    }

    public void setTransition(TransitionLifeline transition) {
        this.transition = transition;
        this.propertyChangeSupport.firePropertyChange(PROPERTY_TRANSITION, this.transition, this.transition);
    }

    public TransitionLifeline getTransition() {
        return this.transition;
    }

    public Set<Symbol> getSymbols() {
        return this.symbols;
    }

    public void setSymbols(Set<Symbol> symbols) {
        this.symbols = symbols;
        this.propertyChangeSupport.firePropertyChange(PROPERTY_SYMBOL, this.symbols, this.symbols);
    }

    public void addSymbol(Symbol symbol) {
        this.propertyChangeSupport.firePropertyChange(PROPERTY_SYMBOL, this.symbols, (Object)this.symbols.add(symbol));
    }

    public int hashCode() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.step);
        for (StateLifeline sl : this.states) {
            sb.append(sl.hashCode());
        }
        for (IntermediateTransition it : this.intermediateTransition) {
            if (it.getTransitionLifeline() == null) continue;
            sb.append(it.getTransitionLifeline().hashCode());
        }
        if (this.transition != null) {
            sb.append(this.transition.hashCode());
        }
        if (this.sentMessage != null) {
            sb.append(this.sentMessage.toString());
        }
        if (this.enclosingMessage != null) {
            sb.append(this.enclosingMessage.toString());
        }
        for (Symbol s : this.symbols) {
            sb.append(s.getName());
        }
        return sb.toString().hashCode();
    }
}

