/*
 * Decompiled with CFR 0.152.
 */
package org.modelevolution.multiview.sc.ui.view;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Shape;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.swt.graphics.Color;
import org.modelevolution.multiview.Lifeline;
import org.modelevolution.multiview.Message;
import org.modelevolution.multiview.Region;
import org.modelevolution.multiview.State;
import org.modelevolution.multiview.Transition;
import org.modelevolution.multiview.mc.encoding.engine.impl.StateLifeline;
import org.modelevolution.multiview.mc.encoding.engine.impl.TransitionLifeline;
import org.modelevolution.multiview.sc.ui.SequenceCheckerUiPlugin;
import org.modelevolution.multiview.sc.ui.model.GlobalState;
import org.modelevolution.multiview.sc.ui.model.IntermediateTransition;

public class ViewUtil {
    private static Map<IFigure, Color> defaultBackgroundColor = new HashMap<IFigure, Color>();
    private static Map<IFigure, Color> defaultForegroundColor = new HashMap<IFigure, Color>();
    public static final Color FOREGROUND_COLOR = ColorConstants.red;
    public static final Color BACKGROUND_COLOR = ColorConstants.orange;
    public static final int ALPHA = 100;
    public static Set<IFigure> currentHighlighting = new HashSet<IFigure>();

    public static void highlightGlobalState(GlobalState gs) {
        HashSet<IFigure> figures = new HashSet<IFigure>();
        figures.add(SequenceCheckerUiPlugin.getDefault().getGlobalStateModel().getCachedFigure((EObject)gs.getEnclosingMessage()));
        for (StateLifeline sl : gs.getStates()) {
            Lifeline ll = sl.getLifeline();
            State s = sl.getState();
            Region rtRegion = SequenceCheckerUiPlugin.getDefault().getGlobalStateModel().getLifeline2regionMap().get(ll.getName());
            for (State rtState : rtRegion.getStates()) {
                if (!rtState.getName().equals(s.getName())) continue;
                figures.add(SequenceCheckerUiPlugin.getDefault().getGlobalStateModel().getCachedFigure((EObject)rtState));
            }
        }
        for (IntermediateTransition it : gs.getIntermediateTransition()) {
            TransitionLifeline tl = it.getTransitionLifeline();
            Lifeline ll = tl.getLifeline();
            Transition t = tl.getTransition();
            ViewUtil.findTransitionFigure(ll, t, figures, true);
        }
        if (gs.getTransition() != null) {
            TransitionLifeline tl = gs.getTransition();
            Lifeline ll = tl.getLifeline();
            Transition t = tl.getTransition();
            ViewUtil.findTransitionFigure(ll, t, figures, false);
        }
        if (gs.getSentMessage() != null) {
            figures.add(SequenceCheckerUiPlugin.getDefault().getGlobalStateModel().getCachedFigure((EObject)gs.getSentMessage()));
        }
        ViewUtil.colorShapes(figures, FOREGROUND_COLOR, BACKGROUND_COLOR, 100, true);
    }

    private static void findTransitionFigure(Lifeline ll, Transition t, Set<IFigure> figures, boolean addStates) {
        Region rtRegion = SequenceCheckerUiPlugin.getDefault().getGlobalStateModel().getLifeline2regionMap().get(ll.getName());
        for (State rtState : rtRegion.getStates()) {
            if (addStates && t.getSource().getName().equals(rtState.getName())) {
                figures.add(SequenceCheckerUiPlugin.getDefault().getGlobalStateModel().getCachedFigure((EObject)rtState));
                continue;
            }
            if (!t.getTarget().getName().equals(rtState.getName())) continue;
            if (addStates) {
                figures.add(SequenceCheckerUiPlugin.getDefault().getGlobalStateModel().getCachedFigure((EObject)rtState));
            }
            for (Transition rtTrans : rtState.getIncoming()) {
                if (!rtTrans.getTarget().getName().equals(t.getTarget().getName()) || rtTrans.getTrigger() != null && !rtTrans.getTrigger().equals(t.getTrigger()) || rtTrans.getEffects() != null && !rtTrans.getEffects().equals((Object)t.getEffects())) continue;
                figures.add(SequenceCheckerUiPlugin.getDefault().getGlobalStateModel().getCachedFigure((EObject)rtTrans));
            }
        }
    }

    private static void colorShapes(Set<IFigure> selectedFigures, Color foregroundcolor, Color backgroundcolor, int alpha, boolean propagateChildren) {
        ViewUtil.resetColors();
        if (selectedFigures != null) {
            for (IFigure f : selectedFigures) {
                if (f == null) continue;
                ViewUtil.highlight(f, foregroundcolor, backgroundcolor, alpha);
                if (propagateChildren) {
                    for (Object o : f.getChildren()) {
                        IFigure c = (IFigure)o;
                        ViewUtil.highlight(c, foregroundcolor, backgroundcolor, alpha);
                    }
                }
                f.repaint();
            }
        }
    }

    private static void setAlpha(IFigure figure, int alpha) {
        if (figure instanceof Shape) {
            ((Shape)figure).setAlpha(alpha);
            List children = figure.getChildren();
            for (Figure child : children) {
                ViewUtil.setAlpha((IFigure)child, alpha);
            }
        }
    }

    private static void persistDefaultColors(IFigure f) {
        if (!defaultBackgroundColor.containsKey(f)) {
            defaultBackgroundColor.put(f, f.getBackgroundColor());
        }
        if (!defaultForegroundColor.containsKey(f)) {
            defaultForegroundColor.put(f, ColorConstants.black);
        }
    }

    private static void resetColors() {
        if (currentHighlighting != null) {
            for (IFigure f : currentHighlighting) {
                f.setForegroundColor(defaultForegroundColor.get(f));
                f.setBackgroundColor(defaultBackgroundColor.get(f));
                ViewUtil.setAlpha(f, 100);
                for (Object o : f.getChildren()) {
                    IFigure c = (IFigure)o;
                    c.setForegroundColor(defaultForegroundColor.get(c));
                    c.setBackgroundColor(defaultBackgroundColor.get(c));
                    ViewUtil.setAlpha(c, 100);
                }
                f.repaint();
            }
        }
        currentHighlighting.clear();
    }

    private static void highlight(IFigure f, Color foregroundcolor, Color backgroundcolor, int alpha) {
        ViewUtil.persistDefaultColors(f);
        f.setForegroundColor(foregroundcolor);
        f.setBackgroundColor(backgroundcolor);
        ViewUtil.setAlpha(f, alpha);
        currentHighlighting.add(f);
    }

    public static IFigure getFigure(EditPart ep) {
        if (ep instanceof GraphicalEditPart) {
            return ((GraphicalEditPart)ep).getFigure();
        }
        if (ep instanceof ConnectionEditPart) {
            return ((ConnectionEditPart)ep).getFigure();
        }
        return null;
    }

    public static EditPart findEditPart(GraphicalEditPart epStart, EObject o) {
        EObject resolvedElement = epStart.resolveSemanticElement();
        if (resolvedElement.eClass() == o.eClass()) {
            EStructuralFeature nameFeature = resolvedElement.eClass().getEStructuralFeature("name");
            if (epStart.resolveSemanticElement().equals(o) || resolvedElement.eGet(nameFeature) != null && resolvedElement.eGet(nameFeature).equals(o.eGet(nameFeature))) {
                return epStart;
            }
        } else {
            List epChildren = epStart.getChildren();
            for (EditPart epNext : epChildren) {
                EditPart epChild;
                if (!(epNext instanceof GraphicalEditPart) || (epChild = ViewUtil.findEditPart((GraphicalEditPart)epNext, o)) == null) continue;
                return epChild;
            }
            List epConnections = epStart.getSourceConnections();
            for (EditPart epNext : epConnections) {
                if (!(epNext instanceof ConnectionEditPart)) continue;
                EObject resolvedConnection = ((ConnectionEditPart)epNext).resolveSemanticElement();
                if (resolvedConnection != null && resolvedConnection.equals(o)) {
                    return epNext;
                }
                if (o instanceof Transition && resolvedConnection instanceof Transition) {
                    Transition oTrans = (Transition)o;
                    Transition rTrans = (Transition)resolvedConnection;
                    if (oTrans.toString().equals(rTrans.toString())) {
                        return epNext;
                    }
                }
                if (!(o instanceof Message) || !(resolvedConnection instanceof Message)) continue;
                Message oMsg = (Message)o;
                Message rMsg = (Message)resolvedConnection;
                if (rMsg.getPosition() != oMsg.getPosition() || rMsg.getSender() == null || oMsg.getSender() == null || !rMsg.getSender().getLifeline().getName().equals(oMsg.getSender().getLifeline().getName()) || rMsg.getReceiver() == null || oMsg.getReceiver() == null || !rMsg.getReceiver().getLifeline().getName().equals(oMsg.getReceiver().getLifeline().getName()) || rMsg.getBody() == null || oMsg.getBody() == null || !rMsg.getBody().getName().equals(oMsg.getBody().getName())) continue;
                return epNext;
            }
        }
        return null;
    }
}

