/*
 * Decompiled with CFR 0.152.
 */
package org.modelevolution.multiview.sc.ui.handler;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.modelevolution.multiview.Lifeline;
import org.modelevolution.multiview.Message;
import org.modelevolution.multiview.MultiviewModel;
import org.modelevolution.multiview.MultiviewPackage;
import org.modelevolution.multiview.Region;
import org.modelevolution.multiview.SequenceView;
import org.modelevolution.multiview.State;
import org.modelevolution.multiview.StateView;
import org.modelevolution.multiview.Transition;
import org.modelevolution.multiview.diagram.edit.parts.MultiviewEditPart;
import org.modelevolution.multiview.diagram.part.MultiviewDiagramEditor;
import org.modelevolution.multiview.diagram.part.MultiviewDiagramEditorUtil;
import org.modelevolution.multiview.sc.ui.SequenceCheckerUiPlugin;
import org.modelevolution.multiview.sc.ui.handler.EvaluationHandler;
import org.modelevolution.multiview.sc.ui.model.GlobalStateModel;
import org.modelevolution.multiview.sc.ui.view.ViewUtil;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.TimeoutException;

public class SCEncodingCommandHandler
extends AbstractHandler {
    private static SCEncodingCommandHandler instance = null;
    private boolean enabled = false;
    private IStructuredSelection selection;
    private MultiviewModel mvModel;
    private MultiviewEditPart mvEditPart;
    private Diagram mvDiagram;
    private EcoreUtil.Copier copier;
    private Resource modelResource;
    private Resource diagramResource;
    private MultiviewModel modelCopy;
    private Diagram diagramCopy;
    private Map<Region, IFigure> staticRegion2FigureMap = new HashMap<Region, IFigure>();
    private Map<Region, Set<Region>> staticRegion2rtRegionsMap = new HashMap<Region, Set<Region>>();
    private Map<Region, Region> rtRegion2staticRegionMap = new HashMap<Region, Region>();

    public SCEncodingCommandHandler() {
        instance = this;
    }

    public static SCEncodingCommandHandler getInstance() {
        if (instance == null) {
            instance = new SCEncodingCommandHandler();
        }
        return instance;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(Object evaluationContext) {
        IEvaluationContext context;
        Object currentSelection;
        this.enabled = false;
        if (evaluationContext != null && evaluationContext instanceof IEvaluationContext && (currentSelection = (context = (IEvaluationContext)evaluationContext).getVariable("selection")) != null && currentSelection instanceof IStructuredSelection) {
            EditPart partSelection;
            Object firstSelection;
            this.selection = (IStructuredSelection)currentSelection;
            if (this.selection.size() == 1 && (firstSelection = this.selection.getFirstElement()) instanceof EditPart && (partSelection = (EditPart)firstSelection).getRoot().getContents() instanceof MultiviewEditPart) {
                this.mvEditPart = (MultiviewEditPart)partSelection.getRoot().getContents();
                this.mvDiagram = (Diagram)this.mvEditPart.getModel();
                EObject model = this.mvDiagram.getElement();
                if (model instanceof MultiviewModel) {
                    this.enabled = true;
                    this.mvModel = (MultiviewModel)model;
                }
            }
        }
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        try {
            this.process();
            SequenceView sequenceViewCopy = this.modelCopy.getSequenceview();
            StateView stateViewCopy = this.modelCopy.getStateview();
            for (Lifeline ll : sequenceViewCopy.getLifelines()) {
                Region staticRegion = ll.getClass_().getStatemachine();
                Region runtimeRegion = (Region)this.copier.copy((EObject)staticRegion);
                this.copier.copyReferences();
                if (this.staticRegion2rtRegionsMap.containsKey(staticRegion)) {
                    this.staticRegion2rtRegionsMap.get(staticRegion).add(runtimeRegion);
                } else {
                    HashSet<Region> rtRegions = new HashSet<Region>();
                    rtRegions.add(runtimeRegion);
                    this.staticRegion2rtRegionsMap.put(staticRegion, rtRegions);
                }
                this.rtRegion2staticRegionMap.put(runtimeRegion, staticRegion);
                for (Iterator s : runtimeRegion.getStates()) {
                    for (Transition t : s.getIncoming()) {
                        for (Map.Entry entry : this.copier.entrySet()) {
                            if (!((EObject)entry.getValue()).equals(t)) continue;
                            Transition originTransition = (Transition)entry.getKey();
                            t.setTrigger(originTransition.getTrigger());
                            t.getEffects().addAll((Collection)originTransition.getEffects());
                        }
                    }
                }
                runtimeRegion.setName(String.valueOf(ll.getName()) + " : " + runtimeRegion.getName());
                stateViewCopy.getStatemachines().add((Object)runtimeRegion);
                SequenceCheckerUiPlugin.getDefault().getGlobalStateModel().putLifeline2regionMapping(ll.getName(), runtimeRegion);
            }
            this.modelResource.save(Collections.EMPTY_MAP);
            MultiviewDiagramEditorUtil.openDiagram((Resource)this.diagramResource);
            IEditorPart editorPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
            if (editorPart instanceof MultiviewDiagramEditor) {
                MultiviewDiagramEditor mvEditor = (MultiviewDiagramEditor)editorPart;
                MultiviewEditPart mvEditPartCopy = (MultiviewEditPart)mvEditor.getDiagramGraphicalViewer().getEditPartRegistry().get(mvEditor.getDiagramEditPart().getNotationView());
                for (Region originRegion : this.mvModel.getStateview().getStatemachines()) {
                    Region r = (Region)this.copier.get((Object)originRegion);
                    EditPart regionEditPart = ViewUtil.findEditPart((GraphicalEditPart)mvEditPartCopy, (EObject)r);
                    IFigure regionFigure = ViewUtil.getFigure(regionEditPart);
                    if (regionFigure != null) {
                        regionFigure.setVisible(false);
                    }
                    this.staticRegion2FigureMap.put(r, regionFigure);
                }
                for (Region rtRegion : stateViewCopy.getStatemachines()) {
                    EditPart regionEditPart = ViewUtil.findEditPart((GraphicalEditPart)mvEditPartCopy, (EObject)rtRegion);
                    IFigure regionFigure = ViewUtil.getFigure(regionEditPart);
                    if (regionFigure == null || !regionFigure.isVisible()) continue;
                    IFigure originRegionFigure = this.staticRegion2FigureMap.get(this.rtRegion2staticRegionMap.get(rtRegion));
                    regionFigure.setPreferredSize(originRegionFigure.getPreferredSize());
                    this.applyLayout(originRegionFigure, regionFigure);
                    SequenceCheckerUiPlugin.getDefault().getGlobalStateModel().cacheFigure((EObject)rtRegion, regionFigure);
                    for (State s : rtRegion.getStates()) {
                        EditPart stateEditPart = ViewUtil.findEditPart((GraphicalEditPart)regionEditPart, (EObject)s);
                        IFigure stateFigure = ViewUtil.getFigure(stateEditPart);
                        if (stateFigure != null) {
                            SequenceCheckerUiPlugin.getDefault().getGlobalStateModel().cacheFigure((EObject)s, stateFigure);
                        }
                        for (Transition t : s.getIncoming()) {
                            EditPart transEditPart = ViewUtil.findEditPart((GraphicalEditPart)regionEditPart, (EObject)t);
                            IFigure transFigure = ViewUtil.getFigure(transEditPart);
                            if (transFigure == null) continue;
                            SequenceCheckerUiPlugin.getDefault().getGlobalStateModel().cacheFigure((EObject)t, transFigure);
                        }
                    }
                }
                EditPart sequenceViewEditPart = ViewUtil.findEditPart((GraphicalEditPart)mvEditPartCopy, (EObject)sequenceViewCopy);
                for (Message msg : sequenceViewCopy.getMessages()) {
                    EditPart msgEditPart = ViewUtil.findEditPart((GraphicalEditPart)sequenceViewEditPart, (EObject)msg);
                    IFigure msgFigure = ViewUtil.getFigure(msgEditPart);
                    if (msgFigure == null) continue;
                    SequenceCheckerUiPlugin.getDefault().getGlobalStateModel().cacheFigure((EObject)msg, msgFigure);
                }
                mvEditPartCopy.refresh();
            }
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            SequenceCheckerUiPlugin.log(Level.SEVERE, "InvocationTargetException:\t" + e.getMessage());
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            SequenceCheckerUiPlugin.log(Level.SEVERE, "InterruptedException:\t" + e.getMessage());
        }
        catch (PartInitException e) {
            e.printStackTrace();
            SequenceCheckerUiPlugin.log(Level.SEVERE, "PartInitException:\t" + e.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
            SequenceCheckerUiPlugin.log(Level.SEVERE, "IOException:\t" + e.getMessage());
        }
        return null;
    }

    private void applyLayout(IFigure originFigure, IFigure copiedFigure) {
        Object[] originChildren = originFigure.getChildren().toArray();
        Object[] copiedChildren = copiedFigure.getChildren().toArray();
        int i = 0;
        while (i < originChildren.length) {
            this.applyLayout((IFigure)originChildren[i], (IFigure)copiedChildren[i]);
            ++i;
        }
        copiedFigure.setSize(originFigure.getBounds().width, originFigure.getBounds().height);
        if (originFigure instanceof NodeFigure) {
            copiedFigure.translate(originFigure.getBounds().x, originFigure.getBounds().y);
        }
        copiedFigure.repaint();
    }

    private void process() throws InvocationTargetException, InterruptedException, IOException {
        this.copyResources();
        SequenceCheckerUiPlugin.getDefault().getWorkbench().getProgressService().run(false, true, new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask("Sequence Checker", 2);
                int bound = 5;
                try {
                    GlobalStateModel gsModel = EvaluationHandler.performEvaluation(SCEncodingCommandHandler.this.modelCopy, bound, monitor);
                    gsModel.alignMessages((EList<Message>)SCEncodingCommandHandler.this.modelCopy.getSequenceview().getOrderedMessages());
                    SequenceCheckerUiPlugin.getDefault().getGlobalStateModel().setLastMsgIndex(gsModel.getLastMsgIndex());
                    SequenceCheckerUiPlugin.getDefault().getGlobalStateModel().setResult(gsModel.getResult());
                    SequenceCheckerUiPlugin.getDefault().getGlobalStateModel().setTraceElements(gsModel.getTrace());
                }
                catch (ContradictionException e) {
                    e.printStackTrace();
                    SequenceCheckerUiPlugin.log(Level.SEVERE, "ContradictionException:\t" + e.getMessage());
                }
                catch (TimeoutException e) {
                    e.printStackTrace();
                    SequenceCheckerUiPlugin.log(Level.SEVERE, "TimeoutException:\t" + e.getMessage());
                }
                monitor.done();
            }
        });
    }

    private void copyResources() throws IOException {
        EPackage.Registry.INSTANCE.put((Object)MultiviewPackage.eINSTANCE.getNsURI(), (Object)MultiviewPackage.eINSTANCE);
        EPackage.Registry.INSTANCE.put((Object)NotationPackage.eINSTANCE.getNsURI(), (Object)NotationPackage.eINSTANCE);
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("mvml", new EcoreResourceFactoryImpl());
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("mvmld", new EcoreResourceFactoryImpl());
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("mvml", new EcoreResourceFactoryImpl());
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("mvmld", new EcoreResourceFactoryImpl());
        URI modelURI = this.mvModel.eResource().getURI();
        URI diagramURI = this.mvDiagram.eResource().getURI();
        String modelCopyFile = String.valueOf(modelURI.trimFileExtension().toPlatformString(false)) + "Copy." + modelURI.fileExtension();
        String diagramCopyFile = String.valueOf(diagramURI.trimFileExtension().toPlatformString(false)) + "Copy." + diagramURI.fileExtension();
        URI modelCopyURI = URI.createPlatformResourceURI((String)modelCopyFile, (boolean)true);
        URI diagramCopyURI = URI.createPlatformResourceURI((String)diagramCopyFile, (boolean)true);
        this.modelResource = resourceSet.createResource(modelCopyURI);
        this.diagramResource = resourceSet.createResource(diagramCopyURI);
        this.copier = new EcoreUtil.Copier();
        this.modelCopy = (MultiviewModel)this.copier.copy((EObject)this.mvModel);
        this.diagramCopy = (Diagram)this.copier.copy((EObject)this.mvDiagram);
        this.copier.copyReferences();
        this.modelResource.getContents().add((Object)this.modelCopy);
        this.diagramResource.getContents().add((Object)this.diagramCopy);
        this.modelResource.save(Collections.EMPTY_MAP);
        this.diagramResource.save(Collections.EMPTY_MAP);
    }
}

