/*
 * Decompiled with CFR 0.152.
 */
package org.modelevolution.multiview.sc.ui.model;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.draw2d.IFigure;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.modelevolution.multiview.Lifeline;
import org.modelevolution.multiview.Message;
import org.modelevolution.multiview.Region;
import org.modelevolution.multiview.mc.encoding.engine.impl.TransitionLifeline;
import org.modelevolution.multiview.sc.ui.handler.ResultType;
import org.modelevolution.multiview.sc.ui.model.GlobalState;

public class GlobalStateModel
implements Serializable {
    private static final long serialVersionUID = 5843967151127227419L;
    public static final String PROPERTY_TRACE = "org.modelevolution.multiview.sc.ui.model.GlobalState";
    private ResultType result = ResultType.NONE;
    private SortedSet<GlobalState> trace = new TreeSet<GlobalState>(new Comparator<GlobalState>(){

        @Override
        public int compare(GlobalState o1, GlobalState o2) {
            if (o1.hashCode() == o2.hashCode()) {
                return 0;
            }
            return Integer.compare(o1.getStep(), o2.getStep());
        }
    });
    private int lastMsgIndex = 0;
    private Map<String, Region> lifeline2regionMap = new HashMap<String, Region>();
    private Map<EObject, IFigure> cachedFigures = new HashMap<EObject, IFigure>();
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public ResultType getResult() {
        return this.result;
    }

    public void setResult(ResultType result) {
        this.result = result;
        this.propertyChangeSupport.firePropertyChange(PROPERTY_TRACE, (Object)this.result, (Object)this.result);
    }

    public void addTraceElement(GlobalState traceElement) {
        PropertyChangeListener[] propertyChangeListenerArray = this.propertyChangeSupport.getPropertyChangeListeners();
        int n = propertyChangeListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyChangeListener listener = propertyChangeListenerArray[n2];
            traceElement.addPropertyChangeListener("org.modelevolution.multiview.sc.ui.model.GlobalState.step", listener);
            traceElement.addPropertyChangeListener("org.modelevolution.multiview.sc.ui.model.GlobalState.globalstate", listener);
            traceElement.addPropertyChangeListener("org.modelevolution.multiview.sc.ui.model.GlobalState.message", listener);
            traceElement.addPropertyChangeListener("org.modelevolution.multiview.sc.ui.model.GlobalState.transition", listener);
            ++n2;
        }
        if (!this.trace.contains(traceElement)) {
            this.propertyChangeSupport.firePropertyChange(PROPERTY_TRACE, this.trace, (Object)this.trace.add(traceElement));
        }
    }

    public void setTraceElements(Collection<GlobalState> traceElements) {
        this.trace.clear();
        this.propertyChangeSupport.firePropertyChange(PROPERTY_TRACE, this.trace, (Object)this.trace.addAll(traceElements));
    }

    public Set<GlobalState> getTrace() {
        return this.trace;
    }

    public int getLastMsgIndex() {
        return this.lastMsgIndex;
    }

    public void setLastMsgIndex(int lastMsgIndex) {
        this.lastMsgIndex = lastMsgIndex;
        this.propertyChangeSupport.firePropertyChange(PROPERTY_TRACE, this.lastMsgIndex, this.lastMsgIndex);
    }

    public Map<String, Region> getLifeline2regionMap() {
        return this.lifeline2regionMap;
    }

    public void putLifeline2regionMapping(String lifeline, Region rtRegion) {
        this.propertyChangeSupport.firePropertyChange(PROPERTY_TRACE, this.lifeline2regionMap, this.lifeline2regionMap.put(lifeline, rtRegion));
    }

    public void cacheFigure(EObject o, IFigure f) {
        this.cachedFigures.put(o, f);
    }

    public IFigure getCachedFigure(EObject o) {
        return this.cachedFigures.get(o);
    }

    public void alignMessages(EList<Message> messages) {
        GlobalState gs;
        int msgIdx = 0;
        GlobalState[] gsArray = new GlobalState[this.trace.size()];
        gsArray = this.trace.toArray(gsArray);
        int i = 0;
        while (i < this.trace.size()) {
            gs = gsArray[i];
            if (gs != null && gs.getTransition() != null && gs.getTransition().getTransition() != null) {
                Lifeline transLL;
                TransitionLifeline tl = gs.getTransition();
                Message msg = (Message)messages.get(msgIdx);
                Lifeline recLL = msg.getReceiver().getLifeline();
                if (recLL.equals(transLL = tl.getLifeline()) && msg.getBody() != null && tl.getTransition().getTrigger() != null && msg.getBody().equals(tl.getTransition().getTrigger())) {
                    gs.setEnclosingMessage(msg);
                    ++msgIdx;
                }
            }
            ++i;
        }
        i = msgIdx;
        while (i < gsArray.length) {
            gs = gsArray[i];
            this.trace.remove(gs);
            ++i;
        }
        i = msgIdx;
        while (i < messages.size()) {
            GlobalState unreachableGs = new GlobalState();
            unreachableGs.setEnclosingMessage((Message)messages.get(i));
            unreachableGs.setStep(i + 1);
            this.trace.add(unreachableGs);
            ++i;
        }
    }
}

