/*
 * Decompiled with CFR 0.152.
 */
package org.modelevolution.multiview;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum MultipleOperandType implements Enumerator
{
    STRICT(0, "STRICT", "STRICT"),
    ALT(1, "ALT", "ALT"),
    PAR(2, "PAR", "PAR"),
    SEQ(3, "SEQ", "SEQ");

    public static final int STRICT_VALUE = 0;
    public static final int ALT_VALUE = 1;
    public static final int PAR_VALUE = 2;
    public static final int SEQ_VALUE = 3;
    private static final MultipleOperandType[] VALUES_ARRAY;
    public static final List<MultipleOperandType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new MultipleOperandType[]{STRICT, ALT, PAR, SEQ};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static MultipleOperandType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            MultipleOperandType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static MultipleOperandType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            MultipleOperandType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static MultipleOperandType get(int value) {
        switch (value) {
            case 0: {
                return STRICT;
            }
            case 1: {
                return ALT;
            }
            case 2: {
                return PAR;
            }
            case 3: {
                return SEQ;
            }
        }
        return null;
    }

    private MultipleOperandType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

